-- V201904131220-SGAppointmentEvent.sql

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPOINTMENT_APPLICANT_PARENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPOINTMENT_APPLICANT_PARENT_RECIPIENT', 'SQL');


SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_APPLICANT_PARENT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPOINTMENT_APPLICANT_PARENT_RECIPIENT');


SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPOINTMENT');
SET @sysmsgevtdefaultconfId = (select id from `sys_msg_evt_default_conf` where `systemMsgEventId` = @sysMsgEventId);
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_APPLICANT_PARENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPOINTMENT_APPLICANT_PARENT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId, @dtproviderId, NULL, @recipientTypeId);


SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_APPLICANT_PARENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"select T1.id as USER_ID from sg_appointment T1 where T1.id in(namedParams)",NULL);


SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_APPLICANT_PARENT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    sg.id AS ID,
    T1.code AS APPLICATION_CODE,
    sg.appointeeName AS APPOINTEE_PRINT_NAME,
    sg.appointeeEmailId AS APPOINTEE_EMAIL_ID,
    DATE_FORMAT(sg.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(sg.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(SUBSTRING_INDEX(personToMeet, '/', - 1)) AS PERSON_TO_MEET,
    T4.academyName AS ACADEMY_NAME,
    T4.locationName AS LOCATION_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T11.`emailId` AS EMAIL_ID,
    T11.`mobileNumber` AS MOBILE_NO,
    T11.`mobileCountryCode` AS MOBILE_CODE,
    T11.`firstName` AS FIRST_NAME,
    T11.`lastName` AS LAST_NAME,
	CONCAT(T6.addressText,' ',T7.cityName,', ',T8.countryName,', ',T9.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
	CONCAT(T6.phoneCountryCode,'-',T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T6.websiteURL AS ACADEMY_LOCATION_URL,
    T10.printName OWNER_NAME,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
	(Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
	INNER JOIN
    application T1 ON T1.id = sg.applicationId
        LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T3 ON T3.applicantPersonId = T2.id
        LEFT JOIN
    applicant_person T11 ON T11.id = T3.relatedApplicantPersonId
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
		LEFT JOIN
    organizations org on org.id = 1
		LEFT OUTER JOIN
	city T7 ON T7.id = T6.cityId
		LEFT OUTER JOIN
	country T8 ON T8.id = T7.countryId
		LEFT OUTER JOIN
	country_region T9 ON T9.id = T7.countryRegionId
		LEFT OUTER JOIN
	users T10 ON T10.id = T1.applicationOwner
WHERE
    sg.id IN (namedParams) AND T3.relationship = 'FATHER'",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "appointeeEmailId",
            "resultKey": "APPOINTEE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "PERSON_TO_MEET",
            "resultKey": "PERSON_TO_MEET",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "appointeePrintName",
            "resultKey": "APPOINTEE_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },        
        {
            "id": 6,
            "value": "APPOINTMENT_DATE",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
	{
            "id": 13,
            "value": "academyLocationAddress",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "academyLocationPhoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "academyLocationEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 14
        },
	{
            "id": 15,
            "value": "academyLocationURL",
            "resultKey": "ACADEMY_LOCATION_URL",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "Owner Name",
            "resultKey": "OWNER_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
	{
            "id": 17,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 16
        },
	{
            "id": 18,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 18
        }
    ]
}');



SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPOINTMENT_APPLICANT_PARENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Applicant Appointment Booked - Parents',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templatedtproviderId+1,NULL,'Applicant Appointment Booked - Parents',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','APPOINTMENT HAS BEEN SCHEDULED','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
	<tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>, please note that <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong> has booked an appointment on <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> at <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> with <strong>$recipientData[&quot;ACADEMY_NAME&quot;]</strong>, which you are welcome to attend.</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">If you have any questions, please contact us on <strong>$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]</strong> or <strong>$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</strong>, alternatively visit our website <strong>$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</strong>.</span></span></p>
<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><br/>
Kind regards, <br/><br/>
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong><br/>
$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
            <td align="right" style="background-color: #f0f0f0; margin:0px; padding:25px"><img height="50" src="$recipientData[&quot;LOGO_URL&quot;]" /></td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" src="$recipientData[&quot;FOOTER_URL&quot;]" width="100%" /></td>
        </tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','APPOINTMENT HAS BEEN SCHEDULED','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
	<tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>, please note that <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong> has booked an appointment on <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> at <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> with <strong>$recipientData[&quot;ACADEMY_NAME&quot;]</strong>, which you are welcome to attend.</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">If you have any questions, please contact us on <strong>$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]</strong> or <strong>$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</strong>, alternatively visit our website <strong>$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</strong>.</span></span></p>
<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><br/>
Kind regards, <br/><br/>
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong><br/>
$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
            <td align="right" style="background-color: #f0f0f0; margin:0px; padding:25px"><img height="50" src="$recipientData[&quot;LOGO_URL&quot;]" /></td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" src="$recipientData[&quot;FOOTER_URL&quot;]" width="100%" /></td>
        </tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;], please note that $recipientData[&quot;APPLICATION_CODE&quot;] has booked an appointment on $recipientData[&quot;APPOINTMENT_DATE&quot;] at $recipientData[&quot;VISIT_TIME&quot;] with $recipientData[&quot;ACADEMY_NAME&quot;], which you are welcome to attend. If you have any questions, please contact us using the details below. Kind regards, $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;], $recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;], $recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;], $recipientData[&quot;ACADEMY_LOCATION_URL&quot;]');

